'use strict';

/* --------------------------------------------------------------
   account_emailaddress.js 2020-02-26
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

gambio.widgets.module('account_emailaddress', [], function (data) {
	'use strict';

	var $this = $(this),
	    $body = $('body'),
	    defaults = {},
	    options = $.extend(true, {}, defaults, data),
	    module = {};

	// ########## HELPER FUNCTIONS ##########

	// (none)

	// ########## INITIALIZATION ##########

	/**
  * Init function of the widget
  * @constructor
  */
	module.init = function (done) {
		var $emailAddress = $('#email_address'),
		    $emailConfirm = $('#email_address_confirm'),
		    $emailInputs = $('#email_address, #email_address_confirm'),
		    $noMatchNote = $('.email-no-match');

		$emailInputs.on('input', function () {
			var emailValue = $emailAddress.val(),
			    confirmValue = $emailConfirm.val();

			if ((emailValue.length > 0 || confirmValue.length > 0) && emailValue !== confirmValue) {
				$noMatchNote.show();
				$emailAddress.closest('div.form-group').addClass('has-error');
				$emailConfirm.closest('div.form-group').addClass('has-error');
			} else {
				$noMatchNote.hide();
				$emailAddress.closest('div.form-group').removeClass('has-error');
				$emailConfirm.closest('div.form-group').removeClass('has-error');
				// remove help text indicating email address already exists
				$emailAddress.closest('div.form-group').find('.help-block').remove();
				$emailConfirm.closest('div.form-group').find('.help-block').remove();
				// check if password is okay and enable submit button upon a valid password
				if (!$('#password-option').hasClass('has-error')) {
					$('button[type="submit"]', $this.closest('form')).removeAttr('disabled');
				}
			}
		});

		done();
	};

	// Return data to widget engine
	return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
